# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.projects.resource_types import assistant_releasers


class SupResource(sdk2.Resource):
    """
    Abstract SUP resource
    """

    releasable = True
    any_arch = False
    releasers = assistant_releasers


class SupQueueLib(SupResource):
    """
    SUP queue library
    """

    arcadia_build_path = 'sup/queue/lib/java/jni/libsup-queue-lib-jni.so'


class SupRatelimiterBin(SupResource):
    """
    SUP ratelimiter binary
    """

    arcadia_build_path = 'sup/ratelimiter/bin/ratelimiter'


class SupSolverBin(SupResource):
    """
    SUP solver binary
    """

    arcadia_build_path = 'sup/solver/bin/solver'


class SupSmokerBin(SupResource):
    """
    SUP smoker binary
    """

    arcadia_build_path = 'sup/queue/tools/smoker/smoker'


class SupBellMlShard(SupResource):
    """
    Shard with user predicts
    """


class SupLbrBin(SupResource):
    """
    SUP lbr binary
    """

    arcadia_build_path = 'sup/lbr/bin/lbr'


class SupGcBin(SupResource):
    """
    SUP gc binary
    """

    arcadia_build_path = 'sup/gc/bin/gc'


class SupLbrReady(SupResource):
    """
    LBR readiness probe (checks that cache is warm enough)
    """

    arcadia_build_path = 'sup/lbr/ready/ready'


class SupMongoProbe(SupResource):
    """
    MongoDB readiness probe
    """
    arcadia_build_path = 'sup/mongo_probe/mongo_probe'


class SupReceiverStatisticsShard(SupResource):
    """
    Shard with push request tag expression resolve statistics
    """

