# -*- coding: utf-8 -*-
import sandbox.sdk2 as sdk2

from sandbox.common.types import task as ctt, resource as ctr

from sandbox.projects.common import binary_task

from sandbox.projects.surfwax.common.flow import parallel
from sandbox.projects.surfwax.resource_types import SurfwaxLayersCache


class SurfwaxSyncResourcesOnAgent(binary_task.LastBinaryTaskRelease, sdk2.Task):
    """
    Caches resources on the current agent
    """

    class Parameters(sdk2.Task.Parameters):
        priority = ctt.Priority(ctt.Priority.Class.BACKGROUND, ctt.Priority.Subclass.LOW)
        binary_task_params = binary_task.binary_release_parameters(stable=True)

        resources = sdk2.parameters.Resource(
            'Resources',
            resource_type=SurfwaxLayersCache,
            multiple=True,
            required=True,
        )

    @property
    def binary_executor_query(self):
        return {
            "owner": "SURFWAX_STAGING_BROWSERS",
            "attrs": {"project": "surfwax", "released": self.Parameters.binary_executor_release_type},
            "state": [ctr.State.READY],
        }

    def on_execute(self):
        super(SurfwaxSyncResourcesOnAgent, self).on_execute()

        parallel(lambda resource: sdk2.ResourceData(resource), self.Parameters.resources)
