# coding: utf-8

class ReportLoadTestResults(object):
    def __init__(self, shoot_id, report_type, only_regression=False):
        from sandbox.projects.tank.lunapark_client.client import LunaparkApiClient
        from sandbox.projects.tank.lunapark_client.settings import LUNAPARK_URL

        self.shoot_id = shoot_id
        self.lunapark_link = '{}/{}'.format(LUNAPARK_URL, str(self.shoot_id))
        self.empty_test = False
        self.result = {
            'meta': {
                'shoot_id': self.shoot_id,
                'lunapark_link': self.lunapark_link
            }
        }
        self.report_type = report_type
        self.only_regression = only_regression
        self.client = LunaparkApiClient()
        self.message = ''

    def const_shoot_info(self):
        message = u'Стрельба постоянной нагрузкой: {}\n'.format(self.lunapark_link)
        version = self.result['summary'].get('ver')
        if version:
            message += u'Версия пакета {}\n'.format(version)
        if not self.empty_test:
            message += self.get_http_distr()
        if not self.empty_test:
            message += self.get_quantiles()

        return message

    def line_shoot_info(self):
        message = u'Стрельба на разладку: {}\n'.format(self.lunapark_link)
        version = self.result['summary'].get('ver')
        if version:
            message += u'Версия пакета {}\n'.format(version)
        if self.result['summary'].get('imbalance_rps'):
            message += u'Разладка на {} rps\n'.format(self.result['summary']['imbalance_rps'])

        return message

    def get_summary(self):
        if not self.result.get('summary'):
            self.result['summary'] = self.client.get_summary(self.shoot_id)

    def get_http_distr(self):
        message = u'Распределение http-кодов:\n'
        http_distr = self.client.get_http(self.shoot_id)
        if http_distr:
            for code in http_distr:
                message += u'{} - {}\n'.format(code['http'], code['percent'])
        else:
            self.empty_test = True
            message += u'Нет данных\n'
        return message

    def get_quantiles(self):
        message = u'Кумулятивные квантили:\n'
        percentiles = self.client.get_percentiles(self.shoot_id)
        if percentiles:
            for quantile in sorted(percentiles, key=lambda k: int(k['percentile']), reverse=True):
                message += u'{}% < {}ms\n'.format(quantile['percentile'], quantile['ms'])
        else:
            self.empty_test = True
            message += u'Нет данных\n'
        return message

    def check_resolution(self):
        if not self.result['summary'].get('component'):
            self.message += u'Стрельба не входит в регрессионные стрельбы\n'
            return

        regression_info = self.client.check_for_sla(self.shoot_id)
        self.result['regression'] = {
            'component': self.result['summary'].get('component'),
            'resolution': regression_info['resolution']
        }

        if regression_info['resolution']:
            self.message += u'Результаты удовлетворяют всем заданным KPI\n'
        else:
            self.result['regression']['failed_kpis'] = regression_info['failed_kpis']
            for kpi in regression_info['failed_kpis']:
                threshold = ''
                kpi_dic = regression_info['failed_kpis'][kpi]
                for failed_value in kpi_dic['failed_values']:
                    current_treshold = (u"expected: %(failed_value)s %(operator)s %(threshold)s, "
                                        u"actual: %(actual)s\n") % dict(kpi_dic['failed_values'][failed_value],
                                                                        failed_value=failed_value)
                    threshold += "\t%s" % current_treshold
                self.message += u'Failed KPIs:\n {dsc}\n {threshold}'.format(dsc=kpi_dic['dsc'], threshold=threshold)

        return regression_info['resolution']

    def build_message(self):
        if 'const' in self.report_type:
            self.message += self.const_shoot_info()
        if 'line' in self.report_type:
            self.message += self.line_shoot_info()
        self.check_resolution()
