from sandbox import sdk2
import sandbox.common.types.task as ctt
import sandbox.common.types.notification as ctn


class StringResource(sdk2.Resource):
    sync_upload_to_mds = True
    log_date = sdk2.parameters.String("some date")


class StringToResource(sdk2.Task):
    """ A simple task which writes URI-style ammo to MDS"""

    class Parameters(sdk2.Task.Parameters):
        ammo = sdk2.parameters.String(
            "Put your URI-style ammo here",
            multiline=True,
            default="/ping"
            )
        main_number = sdk2.parameters.Integer('Temporary parameter', default=0)

    def on_save(self):
        self.Parameters.notifications = [
            sdk2.Notification(
                [
                    ctt.Status.FAILURE,
                    ctt.Status.EXCEPTION,
                    ctt.Status.NO_RES,
                    ctt.Status.TIMEOUT,
                    ctt.Status.EXPIRED,
                ],
                ['host=firestarter_sandbox&service=execution_status'],
                ctn.Transport.JUGGLER,
                check_status=ctn.JugglerStatus.CRIT
            ),
            sdk2.Notification(
                [
                    ctt.Status.SUCCESS
                ],
                ['host=firestarter_sandbox&service=execution_status'],
                ctn.Transport.JUGGLER,
                check_status=ctn.JugglerStatus.OK
            )
        ]

    def on_execute(self):
        if self.Parameters.main_number == 0:
            resource = StringResource(self, "Output file", "ammo.txt", log_date="08.05.2020")
            data = sdk2.ResourceData(resource)
            data.path.write_bytes(self.Parameters.ammo.encode("utf-8"))
            data.ready()
        if self.Parameters.main_number == 1:
            print('Hooray')
        else:
            raise ValueError
