# -*- coding: utf-8 -*-
import logging

from sandbox import sdk2
from sandbox.common.types import task as ctt
from sandbox.projects.tank.load_resources.resources import YANDEX_TANK_LXC_CONTAINER
from sandbox.projects.sandbox.sandbox_lxc_image import SandboxLxcImage, UbuntuRelease
from sandbox.projects.tank.Firestarter import Firestarter


CUSTOM_REPOS = '''deb http://dist.yandex.ru/yandex-xenial stable/all/
deb http://dist.yandex.ru/yandex-xenial stable/amd64/
deb http://load-xenial.dist.yandex.ru/load-xenial stable/all/
deb http://load-xenial.dist.yandex.ru/load-xenial stable/amd64/
'''
CUSTOM_PACKAGES = 'git software-properties-common  libticket-parser2-python yandex-telegraf load-pandora=0.3.0'
CUSTOM_SCRIPT = '''#!/usr/bin/env bash
set -ex
apt-get install -yq curl wget

### install tank-internal
add-apt-repository ppa:yandex-load/main -y && \
apt-get update -q && \
apt-get install -yq yandex-tank-internal \
        phantom \
        phantom-ssl \

### check tvm2 lib
apt-cache policy  libticket-parser2-python

### clean apt archives
apt-get clean
apt-get autoclean
rm -f /var/cache/apt/*.bin
rm -rf /var/lib/apt/lists/* /var/cache/apt/archives/* /root/.cache/*
'''
RESOURSE_DESCRIPTION = 'Container with the yandex_tank for the shootings via sandbox'
SHOOTING_CONFIG = '''phantom:
  address: 'lee.tanks.yandex.net:8083'
  enabled: true
  load_profile: {load_type: rps, schedule: 'const(1,20s)'}
  uris: [/ /ping]
uploader:
  operator: lunapark
  enabled: true
  package: yandextank.plugins.DataUploader
  task: LOAD-666
metaconf:
  enabled: true
  package: yandextank.plugins.MetaConf
  firestarter:
    tank: sandbox
'''


def build_tank_lxc_container(parent):
    try:
        build_subtask = SandboxLxcImage(
            parent,
            owner=parent.owner,
            resource_type=YANDEX_TANK_LXC_CONTAINER,
            resource_description=RESOURSE_DESCRIPTION,
            ubuntu_release=UbuntuRelease.XENIAL,
            custom_image=True,
            custom_repos=CUSTOM_REPOS,
            custom_script=CUSTOM_SCRIPT,
            custom_packages=CUSTOM_PACKAGES,
        )
        build_subtask.enqueue()
        logging.info('[BUILD LXC] subtask id: %s', build_subtask.id)
        return build_subtask
    except Exception:
        logging.debug('[BUILD LXC] Failed to build LXC container for sandbox tank.')


def release_lxc_sandbox_resource(build_task_id):
    build_tank_lxc_subtask = sdk2.Task.find(id=build_task_id).first()
    logging.info('[RELEASE LXC] Sandbox task %s has status: %s', build_task_id, build_tank_lxc_subtask.status)
    if build_tank_lxc_subtask.status == ctt.Status.SUCCESS:
        build_tank_lxc_subtask.mark_released_resources('stable', ttl='inf')
    else:
        logging.debug('[RELEASE LXC] Sandbox task %s isn\'t success. Is nothig to release.', build_task_id)
        return

    for resource in sdk2.Resource.find(task=build_tank_lxc_subtask, resource_type=YANDEX_TANK_LXC_CONTAINER).limit(0):
        setattr(resource, 'purpose', 'Firestarter')
        logging.info(
            '[RELEASE LXC] resource %s\nreleased: %s\npurpose: %s\nttl: %s',
            resource,
            getattr(resource, 'released'),
            getattr(resource, 'purpose'),
            getattr(resource, 'ttl')
        )


def test_sandbox_tank_shooting(parent):
    try:
        shooting_subtask = Firestarter(
            parent,
            tank_config=SHOOTING_CONFIG
        )
        shooting_subtask.enqueue()
        logging.info('[TEST LXC] Test shooting id %s.', shooting_subtask.id)
        return shooting_subtask
    except Exception:
        logging.info('[TEST LXC] Failed to run test shooting via sandbox tank.')


def check_test_tank_shooting_result(shoot_task_id, build_task_id):
    shooting_subtask = sdk2.Task.find(id=shoot_task_id).first()
    if shooting_subtask.status == ctt.Status.SUCCESS and shooting_subtask.Parameters.lunapark_id:
        logging.info('[TEST LXC] Test shooting was success!')
    else:
        logging.debug('[TEST LXC] Test failed! LXC container will be removed.')
        build_tank_lxc_subtask = sdk2.Task.find(id=build_task_id).first()
        for resource in sdk2.Resource.find(task=build_tank_lxc_subtask, resource_type=YANDEX_TANK_LXC_CONTAINER).limit(0):
            setattr(resource, 'released', 'notstable')
            setattr(resource, 'ttl', '1')
