import os
import tempfile

from sandbox import sdk2
from sandbox.sdk2.helpers import ProcessLog
from sandbox.sdk2.helpers import subprocess as sp


SHELL_SCRIPT = """
. /usr/local/vennv/bin/activate && \
python ./test_python.py

"""

PYTHON_SCRIPT = """import sys


def check_python():
    return sys.maxunicode


if __name__ == '__main__':
    print(check_python())"""


class LoadYourScript(sdk2.Task):
    """
        Run shell or python script on sandbox host in container.
    """

    class Requirements(sdk2.Requirements):
        disk_space = 1024 * 10

    class Context(sdk2.Context):
        pass

    class Parameters(sdk2.Parameters):
        _container = sdk2.parameters.Container(
            "tvm2 environment container",
            default_value=513532842,
            required=True
        )
        shell_script = sdk2.parameters.String(
            'Shell script', multiline=True,
            default=SHELL_SCRIPT
        )
        python_script = sdk2.parameters.String(
            'Python script', multiline=True,
            default=PYTHON_SCRIPT
        )

    def on_execute(self):
        temp_dir = tempfile.mkdtemp()
        test_python_path = os.path.join(temp_dir, 'test_python.py')
        with open(test_python_path, 'w') as output:
            output.write(self.Parameters.python_script)

        with ProcessLog(self, 'script_output') as pl:
            status = sp.check_output(self.Parameters.shell_script, stderr=pl.stdout, shell=True, cwd=temp_dir)
            self.set_info('{}'.format(status))
