# -*- coding: utf-8 -*-

from functools import wraps

def retry(tries=1, delay=1):
    def deco_retry(func):
        @wraps(func)
        def func_retry(*args, **kwargs):
            my_tries, my_delay = tries, delay
            while my_tries > -1:
                try:
                    return func(*args, **kwargs)
                except Exception as err:
                    msg = '%s - %s. retrying in %d seconds' % (func.func_name,
                                                               str(err),
                                                               my_delay)
                    my_tries -= 1
                    if my_tries == -1:
                        return False
                    logging.debug(msg)
                    time.sleep(my_delay)
        return func_retry
    return deco_retry
