from sandbox import sdk2
from sandbox.projects.sandbox.resources import LXC_CONTAINER


class YANDEX_TANK_VIRTUALENV_18(sdk2.Resource):
    """
        Virtualenv for Yandex.Tank (1.8)
    """
    releasable = True
    any_arch = False
    auto_backup = True


class YANDEX_TANK_VIRTUALENV_19(sdk2.Resource):
    """
        Virtualenv for Yandex.Tank (1.9)
    """
    releasable = True
    any_arch = False
    auto_backup = True


class PHANTOM_EXECUTABLE(sdk2.Resource):
    """
        phantom executable
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    arcadia_build_path = 'contrib/phantom/phantom_bin'


class QLOUD_ENV_DUMP(sdk2.Resource):
    """
        String with qloud environment dump
    """
    auto_backup = True


class TANK_PBUILDER_IMAGE(sdk2.Resource):
    """
        The result of pbuilder --create
    """
    releasable = True
    any_arch = False
    auto_backup = True


class TANK_DEB_PACKAGE(sdk2.Resource):
    """
        Resource with tank deb package
    """
    releasable = True
    version = sdk2.parameters.String('Package version')
    package = sdk2.parameters.String('Package name')
    distro = sdk2.parameters.String('Ubuntu distro name')


class TANK_PY_PACKAGE(sdk2.Resource):
    """
        Resource with tank py_package in tar.gz for pypi
    """
    releasable = True
    version = sdk2.parameters.String('Package version')
    package = sdk2.parameters.String('Package name')


class LUNAPARK_DEB_PACKAGE(sdk2.Resource):
    """
        Resource with lunapark deb package
    """
    releasable = True
    version = sdk2.parameters.String('Package version')
    package = sdk2.parameters.String('Package name')
    distro = sdk2.parameters.String('Ubuntu distro name')


class OVERLOAD_DEB_PACKAGE(sdk2.Resource):
    """
        Resource with overload deb package
    """
    releasable = True
    version = sdk2.parameters.String('Package version')
    package = sdk2.parameters.String('Package name')
    distro = sdk2.parameters.String('Ubuntu distro name')


class STRESS_SESSION_IDS(sdk2.Resource):
    """
        Resource with stress cookies
    """
    executable = False
    label = sdk2.parameters.String('Label')


class AMMO_FILE(sdk2.Resource):
    """
        Resource with ammofile for YandexTank
    """
    ammo_label = sdk2.parameters.String('Ammo label')
    ammo_format = sdk2.parameters.String('Ammo format')


class YANDEX_TANKAPI_LXC_CONTAINER(LXC_CONTAINER):
    """
        Tarball with LXC image containing tankapi client
    """
    __default_attribute__ = sdk2.parameters.String

    any_arch = False
    executable = False
    releasable = True


class YANDEX_TANK_LXC_CONTAINER(LXC_CONTAINER):
    """
        Tarball with LXC image containing tankapi client
    """
    __default_attribute__ = sdk2.parameters.String

    any_arch = False
    executable = False
    releasable = True


class LOAD_BUILD_ARTEFACT(sdk2.Resource):
    """
    Ya.Deploy Tank packages
    """
    releasable = True
    any_arch = False
    releasers = ['robot-lunapark', 'LOAD', 'NANNY', 'LOAD-ROBOT']
    auto_backup = True


class TankPackage(LOAD_BUILD_ARTEFACT):
    """
    Ya.Deploy Tank packages
    """


class TANK_FINDER_BUILD(LOAD_BUILD_ARTEFACT):
    """
    Resource for the release of the tank_finder
    """


class LUNAPI_BUILD(LOAD_BUILD_ARTEFACT):
    """
    Resource for the release of the lunaparkapi build
    """


class YANDEX_TANK_LOGS(sdk2.Resource):
    """
    Results of Yandex.Tank fire
    """
    any_arch = True
    executable = False
    releasable = False
    auto_backup = True
