from sandbox.sandboxsdk import environments


_PHOUT_HEADER = [
    "time",            # timestamp
    "tag",             # request tags separated by '|'
    "interval_real",   # full time of request processing in microseconds
    "connect_time",    # connection time in microseconds
    "send_time",       # data sending time in microseconds
    "latency",         # time spent inside server in microseconds
    "receive_time",    # data receiving time in microseconds
    "interval_event",  # time spent in load generator in microseconds
    "size_out",        # response size in bytes
    "size_in",         # request size in bytes
    "net_code",        # libc errno
    "proto_code",      # HTTP protocol code
]

ENVIRONMENT = (
    environments.PipEnvironment(
        "pandas", "0.17.0",
        use_wheel=True, custom_parameters=["--ignore-installed"]
    ),
)


def get_phout(dump_path):
    """
        Reads phout data to pandas.DataFrame object
    """
    import pandas
    # TODO: read rps directly from some json stats file
    df = pandas.read_csv(dump_path, sep='\t', names=_PHOUT_HEADER, header=None)
    df = df[df.net_code == 0]  # filter out requests with network errors
    return df
