# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.parameters import Container
from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.sandboxsdk.parameters import SandboxBoolParameter
from sandbox.projects.common.build import YaPackage
from sandbox.projects.common.constants import SANDBOX_CONTAINER

from sandbox.projects.common.nanny import nanny
import taxi_resource_types


class ContainerParameter(Container):
    name = SANDBOX_CONTAINER
    description = 'Container the task should execute in'
    default_value = 773239891
    required = True


class DeployEnvironment(SandboxStringParameter):
    name = "deploy_environment"
    description = "Environment for auto deploy (prestable|stable|testing). Default is testing"
    default_value = "testing"
    required = False


class ServiceSuffix(SandboxStringParameter):
    name = "taxi-service"
    description = "Taxi service suffix. Default is dispatcher"
    default_value = "dispatcher"
    required = False


class RebuildAll(SandboxBoolParameter):
    name = "rebuild_all"
    description = "Make full rebuild and replace on upload"
    default_value = True
    required = False


class LogisticDispatcherYaPackage(YaPackage.YaPackage):
    type = 'LOGISTIC_DISPATCHER_YA_PACKAGE'

    input_parameters = [
        YaPackage.parameters.ArcadiaUrl,
        ContainerParameter,
        DeployEnvironment,
        ServiceSuffix,
        RebuildAll,
        # YaPackage.parameters.BuildType,
    ]

    def _get_package_path(self):
        env_mapping = {
            'testing': 'testing',
            'prestable': 'prestable',
            'stable': 'stable',
        }
        arc_path = "taxi/logistic-dispatcher/%s/docker/%s/package.json"
        return arc_path % (self.ctx.get(ServiceSuffix.name), env_mapping.get(self.ctx.get(DeployEnvironment.name), 'testing'))

    def _get_image_prefix(self):
        image_prefix = "taxi/logistic-%s"
        return image_prefix % self.ctx.get(ServiceSuffix.name)

    def on_enqueue(self):

        self.ctx[YaPackage.PackageTypeParameter.name] = YaPackage.DOCKER
        self.ctx[YaPackage.ResourceTypeParameter.name] = "LOGISTIC_DISPATCHER_YA_PACKAGE"
        self.ctx[YaPackage.PackagesParameter.name] = self._get_package_path()
        self.ctx[YaPackage.DockerImageRepositoryParameter.name] = self._get_image_prefix()
        self.ctx[YaPackage.parameters.BuildType.name] = YaPackage.RELEASE
        self.ctx[YaPackage.CompressPackageArchiveParameter.name] = True
        self.ctx[YaPackage.StripBinariesParameter.name] = False
        self.ctx[YaPackage.DockerPushImageParameter.name] = True
        self.ctx[YaPackage.DockerSaveImageParameter.name] = False
        self.ctx[YaPackage.DockerRegistryParameter.name] = "registry.yandex.net"
        self.ctx[YaPackage.DockerUserParameter.name] = "nsofya"
        self.ctx[YaPackage.DockerTokenVaultName.name] = "nsofya_docker_token"
        YaPackage.YaPackage.on_enqueue(self)

    def on_execute(self):
        if self.ctx.get(RebuildAll.name):
            YaPackage.YaPackage.on_execute(self)

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        YaPackage.YaPackage.on_release(self, additional_parameters)
