# coding: utf-8
from sandbox import sdk2

import sandbox.projects.resource_types.releasers as releasers

# for backward compatibility, do not use it, use sdk2.Resource instead
AbstractResource = sdk2.resource.AbstractResource


class TAXI_DISPATCHER(AbstractResource):
    """
        Taxi related resource
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = releasers.logistic_releasers
    arcadia_build_path = 'taxi/logistic-dispatcher/dispatcher'


class ROBOWAREHOUSE_API_BINARY(sdk2.Resource):
    """Robowarehouse API binary"""

    releasable = True
    auto_backup = True
    any_arch = False
    executable = True
    releasers = ['ROBOWAREHOUSE']


class ROBOWAREHOUSE_CLI_BINARY(sdk2.Resource):
    """Robowarehouse CLI binary"""

    releasable = True
    auto_backup = True
    any_arch = False
    executable = True
    releasers = ['ROBOWAREHOUSE']


class ROBOWAREHOUSE_MIGRATOR_BINARY(sdk2.Resource):
    """Robowarehouse migrator binary"""

    releasable = True
    auto_backup = True
    any_arch = False
    executable = True
    releasers = ['ROBOWAREHOUSE']


class ROBOWAREHOUSE_QUEUE_BINARY(sdk2.Resource):
    """Robowarehouse queue binary"""

    releasable = True
    auto_backup = True
    any_arch = False
    executable = True
    releasers = ['ROBOWAREHOUSE']


class ROBOWAREHOUSE_CELERY_WORKER(sdk2.Resource):
    """Robowarehouse celery worker binary"""

    releasable = True
    auto_backup = True
    any_arch = False
    executable = True
    releasers = ['ROBOWAREHOUSE']


class ROBOWAREHOUSE_CELERY_SCHEDULER(sdk2.Resource):
    """Robowarehouse celery scheduler binary"""

    releasable = True
    auto_backup = True
    any_arch = False
    executable = True
    releasers = ['ROBOWAREHOUSE']


class TaxiExternal(sdk2.Resource):
    """Taxi external projects backups and binaries"""

    auto_backup = True
    share = False
