import logging
from sandbox import sdk2
import subprocess
import sandbox.common.types.misc as ctm
from sandbox.projects.telephony import TelephonyFlutterResource


class TelephonyFlutterResourceTask(sdk2.Task):
    """ Flutter resource maker for Telephony mobile app """

    class Requirements(sdk2.Requirements):
        dns = ctm.DnsType.DNS64
        container_resource = 1828000044

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 3600
        flutter_url = sdk2.parameters.String('Url to a flutter tar archive', required=True)
        flatter_tar_name = sdk2.parameters.String('Flutter archive name', required=True)

    def run_command(_, cmd, process_log):
        try:
            logging.info('Start to execute {}.'.format(cmd))
            subprocess.check_call(cmd.split(' '), stdout=process_log.stdout, stderr=process_log.stdout)
            logging.info('{} executed.'.format(cmd))
        except subprocess.CalledProcessError as err:
            raise RuntimeError('{cmd} failed: {err}\n'.format(cmd=cmd, err=err))

    def on_execute(self):
        with sdk2.helpers.ProcessLog(self, logger="main_log") as pl:
            self.run_command(' '.join(['curl -O', self.Parameters.flutter_url]), pl)
            self.run_command(' '.join(['tar xf', self.Parameters.flatter_tar_name]), pl)
            resource = TelephonyFlutterResource(self, self.Parameters.flatter_tar_name, 'flutter')

            data = sdk2.ResourceData(resource)

            data.ready()
