# coding=utf-8
import os
import subprocess
import logging

from sandbox import sdk2
import sandbox.common.types.misc as ctm
from sandbox.projects.telephony import TelephonyFlutterResource
from sandbox.projects.common.arcadia import sdk as arcadia_sdk


class TelephonyPbxMobileTestRunner(sdk2.Task):
    """ Test and lint runner for telephony mobile app """

    class Requirements(sdk2.Task.Requirements):
        """
        Используется кастомный LXC контейнер с установленными пакетами для flutter.
        Таска, создающая этот ресурс: https://sandbox.yandex-team.ru/task/820768089/resources
        """
        dns = ctm.DnsType.DNS64
        container_resource = 1828000044

    class Parameters(sdk2.Parameters):
        kill_timeout = 20 * 60
        commit_hash = sdk2.parameters.String("Arc commit hash, without #", required=True)
        flutter_resource_id = sdk2.parameters.String("Flutter resource id", required=True)

    def run_command(_, cmd, cwd, process_log):
        try:
            logging.info('Start to execute {}'.format(cmd))
            subprocess.check_call(cmd.split(' '), stdout=process_log.stdout, stderr=process_log.stdout, cwd=cwd)
            logging.info('{} executed.'.format(cmd))
        except subprocess.CalledProcessError as err:
            raise RuntimeError('{cmd} failed: {err}\n'.format(cmd=cmd, err=err))

    def on_execute(self):
        project_path = 'yabs/telephony/mobile/pbx_app/'
        flutter_resource = sdk2.Resource.find(type=TelephonyFlutterResource, id=self.Parameters.flutter_resource_id).first()
        resource_data = sdk2.ResourceData(flutter_resource)
        flutter_path = os.path.join(str(resource_data.path), 'bin')

        with arcadia_sdk.mount_arc_path('arcadia-arc://#' + self.Parameters.commit_hash) as arcadia_src_dir:
            cwd = os.path.join(arcadia_src_dir, project_path)

            with sdk2.helpers.ProcessLog(self, logger="lint_logs") as pl:
                self.run_command('chmod 777 -R .', str(resource_data.path), pl)  # flutter needs these permissions
                self.run_command(flutter_path + '/flutter analyze', cwd, pl)

                # check_unused_cmd = 'check-unused-files lib | grep "Unused file:" && exit 1 || true'
                # self.run_command(flutter_path + '/flutter pub run dart_code_metrics:metrics ' + check_unused_cmd, cwd, pl)

                analyze_cmd = 'analyze lib --set-exit-on-violation-level=alarm --source-lines-of-code=500'
                self.run_command(flutter_path + '/flutter pub run dart_code_metrics:metrics ' + analyze_cmd, cwd, pl)

            with sdk2.helpers.ProcessLog(self, logger="test_logs") as pl:
                self.run_command(flutter_path + '/flutter test --no-sound-null-safety', cwd, pl)
