from sandbox import sdk2


class TELEPHONY_FREESWITCH(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String
    auto_backup = True
    any_arch = False


class TELEPHONY_NGINX(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String
    ttl = 'inf'
    auto_backup = True
    any_arch = False


class YA_CALLS_CALL_CENTER_API(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String
    auto_backup = True
    any_arch = False


class TelephonyNode(sdk2.Resource):
    """
    Telephony Node.js distributable
    """
    __default_attribute__ = sdk2.parameters.String
    ttl = 'inf'
    auto_backup = True
    any_arch = False


class TelephonyFlutterResource(sdk2.Resource):
    """ Flutter resource for Telephony mobile app """
    any_arch = False
    auto_backup = True
    ttl = 365
    sync_upload_to_mds = True


class TELEPHONY_SIP_GATEWAY(sdk2.Resource):
    releasable = True
    auto_backup = True
    releasers = ["TELEPHONY-DEV"]


class TELEPHONY_S3_GATEWAY(sdk2.Resource):
    releasable = True
    auto_backup = True
    releasers = ["TELEPHONY-DEV"]
