# coding=utf-8

import json
import logging

from sandbox import sdk2
import sandbox.projects.traffic.dns.lib.telegram as telegram
import sandbox.projects.traffic.dns.lib.abc as abc
import sandbox.projects.traffic.dns.lib.staff as staff


class DnsDutyNotification(sdk2.Task):
    """Забираем дежурного из АБЦ и рапортуем через NyanBot"""

    class Parameters(sdk2.Task.Parameters):
        abc_num = sdk2.parameters.Integer("UID ABC сервиса(под названием с сервиса в АБЦ)", default=1115,
                                          required=True)
        duty_slug = sdk2.parameters.String("Slug графика дежурств(можно посмотреть в настройках Графика дежурств)",
                                           default="corpdns_dnsrequest_duty", required=True)
        tg_chat_id = sdk2.parameters.Integer("chat id в Telegram", default=-1001194645189, required=True)
        msg_to_tg_chat = sdk2.parameters.String("Сообщение в чат куда допишется ФИО и логин дежурного",
                                                default="Today DNSREQUESTS duty is:", required=True)
        abc_oauth = sdk2.parameters.YavSecret('YAV секрет с OAuth токенами для доступа к ABC',
                                              default="sec-01fwe76ft7g3ng164pck3801w0", required=True)

    def on_execute(self):
        # Get duty
        duty_resp, ok = abc.get_abc_duty(self.Parameters.abc_oauth.data()['abc-oauth'],
                                         self.Parameters.abc_num,
                                         self.Parameters.duty_slug)
        if not ok:
            return
        abc_duty_from_json = json.loads(duty_resp)
        if len(abc_duty_from_json) < 1:
            logging.error("duty not found in response: %s", abc_duty_from_json)
            return
        login = abc_duty_from_json[0]['person']['login']
        fn = abc_duty_from_json[0]['person']['first_name']['ru']
        ln = abc_duty_from_json[0]['person']['last_name']['ru']
        get_tg_login, ok = staff.get_tg_login_by_staff(self.Parameters.abc_oauth.data()['abc-oauth'], login)
        if not ok:
            return
        tg_login = json.loads(get_tg_login)
        if len(tg_login['result'][0]['telegram_accounts']) == 0:
            tg_login = "TG login not found AHTUNG"
        else:
            tg_login = tg_login['result'][0]['telegram_accounts'][0]['value']
        if login != "" and fn != "" and ln != "":
            send, ok = telegram.send_notification_to_tg(self.Parameters.tg_chat_id, login, fn, ln, tg_login,
                                                        self.Parameters.msg_to_tg_chat)
            logging.info("result of send to nyanbot: %s %s", send, ok)
        else:
            logging.error("some errors in login/first_name/last_name and msg: %s %s %s %s", login, fn, ln,
                          self.Parameters.msg_to_tg_chat)
            return
