# coding=utf-8

import json
import logging

from sandbox import sdk2
from sandbox.projects.traffic.dns.lib import telegram, abc, staff


class DnsDutyNotificationNewAbcApi(sdk2.Task):
    """Забираем дежурного из нового календаря дежурств АБЦ и рапортуем через NyanBot"""

    class Parameters(sdk2.Task.Parameters):
        schedule_id = sdk2.parameters.Integer("schedule_id в ABC(ABC->Дежурства 2.0->Нажать на название дежурства)",
                                              default=30397,
                                              required=True)
        tg_chat_id = sdk2.parameters.Integer("chat id в Telegram",
                                             default=-1001194645189,  # for test -1001180871964
                                             required=True)
        msg_to_tg_chat = sdk2.parameters.String("Сообщение в чат куда допишется ФИО и логин дежурного",
                                                default="The next 7 days duty for SaveDNS is:",
                                                required=True)
        tvm_id = sdk2.parameters.Integer("tvm id сервиса от которого будет запрос(по умолчанию от safedns)",
                                         default=2034805,
                                         required=True)
        abc_oauth = sdk2.parameters.YavSecret('YAV секрет с OAuth токенами для доступа к ABC',
                                              default="sec-01fwe76ft7g3ng164pck3801w0",
                                              required=True)

    def on_execute(self):
        # Get tvm
        tvm_service_ticket = self.__get_tvm_ticket(abc.ABC_TVM_PROD)
        if len(tvm_service_ticket) == 0:
            logging.error("exit with errors, because some problems with get tvm service ticket, see above")
            return
        # Get duty
        duty_resp, ok = abc.get_watcher_abc_duty(tvm_service_ticket, self.Parameters.schedule_id)
        if not ok:
            return
        abc_duty_from_json = json.loads(duty_resp)
        if len(abc_duty_from_json['result']) == 0 or "staff" not in abc_duty_from_json['result'][0]:
            logging.error("duty not found in response: %s", abc_duty_from_json)
            return
        login = abc_duty_from_json['result'][0]['staff']['login']
        fn = abc_duty_from_json['result'][0]['staff']['first_name']
        ln = abc_duty_from_json['result'][0]['staff']['last_name']
        get_tg_login, ok = staff.get_tg_login_by_staff(self.Parameters.abc_oauth.data()['abc-oauth'], login)
        if not ok:
            return
        tg_login = json.loads(get_tg_login)
        if len(tg_login['result'][0]['telegram_accounts']) == 0:
            tg_login = "TG login not found AHTUNG"
        else:
            tg_login = tg_login['result'][0]['telegram_accounts'][0]['value']
        if login != "" and fn != "" and ln != "":
            send, ok = telegram.send_notification_to_tg(self.Parameters.tg_chat_id, login, fn, ln, tg_login,
                                                        self.Parameters.msg_to_tg_chat)
            logging.info("result of send to nyanbot: %s %s", send, ok)
        else:
            logging.error("some errors in login/first_name/last_name and msg: %s %s %s %s", login, fn, ln,
                          self.Parameters.msg_to_tg_chat)
            return

    def __get_tvm_ticket(self, dst_tvm_id):
        from tvmauth import TvmClient, TvmApiClientSettings
        from tvmauth.exceptions import BrokenTvmClientSettings, NonRetriableException, RetriableException

        try:
            tvm_client = TvmClient(
                TvmApiClientSettings(
                    self_tvm_id=self.Parameters.tvm_id,
                    self_secret=self.Parameters.abc_oauth.data()['tvm-safedns_tvm'],
                    dsts=[dst_tvm_id],
                )
            )
            return tvm_client.get_service_ticket_for(tvm_id=dst_tvm_id)
        except (BrokenTvmClientSettings, NonRetriableException, RetriableException) as ex:
            logging.error("get_tvm_ticket exceptions: %s", ex)
            return ""
