# coding=utf-8

import logging
import requests

ABC_DUTY_URL = "https://abc-back.yandex-team.ru/api/v4/duty/on_duty/?service={}&schedule.slug={}" \
               "&fields=person.login,person.first_name,person.last_name"
ABC_WATCHER_DUTY_URL = "https://abc-back.yandex-team.ru/api/watcher/v1/shift/?filter=schedule_id={}&current=True"
ABC_TVM_PROD = 2027882


def get_abc_duty(abc_oauth, abc_num, duty_slug):
    try:
        headers = {
            'Authorization': 'OAuth {}'.format(abc_oauth)
        }
        r = ABC_DUTY_URL.format(abc_num, duty_slug)
        result = requests.get(r, headers=headers)
        if result.status_code != 200:
            logging.error("Error get abc duty %s and returned %d", result.content, result.status_code)
            return "", False
    except requests.RequestException as error:
        logging.error("Error occurred while get abc duty: '%s'.", error)
        return "", False
    logging.info("Get abc duty successfully")
    return result.text, True


def get_watcher_abc_duty(service_token, schedule_id):
    try:
        headers = {
            'X-Ya-Service-Ticket': '{}'.format(service_token),
            'Content-Type': 'application/json'
        }
        r = ABC_WATCHER_DUTY_URL.format(schedule_id)
        result = requests.get(r, headers=headers)
        if result.status_code != 200:
            logging.error("Error get abc duty %s and returned %d", result.content, result.status_code)
            return "", False
    except requests.RequestException as error:
        logging.error("Error occurred while get abc duty: '%s'.", error)
        return "", False
    logging.info("Get abc duty successfully")
    return result.text, True
