# coding=utf-8

import logging
import requests

STAFF_API_URL = "https://staff-api.yandex-team.ru/v3/persons?login={}&_fields=telegram_accounts.value,login"


def get_tg_login_by_staff(token, staff_login):
    try:
        abc_oauth = token
        headers = {
            'Authorization': 'OAuth {}'.format(abc_oauth)
        }
        r = STAFF_API_URL.format(staff_login)
        result = requests.get(r, headers=headers)
        if result.status_code != 200:
            logging.error("Error get tg login %s and returned %d", result.content, result.status_code)
            return "", False
    except requests.RequestException as error:
        logging.error("Error occured while get tg login: '%s'.", error)
        return "", False
    logging.info("Get tg login successfuly")
    return result.text, True
