# coding=utf-8

import logging

import requests

NYANBOT_API = "https://api.nbt.media.yandex.net/v2/proxy/telegram/raw/{}"


def send_notification_to_tg(chat_id, login, fn, ln, tg_login, msg):
    try:
        headers = {
            'Content-Type': 'application/json',
            'Accept': 'application/json'
        }
        r = NYANBOT_API.format(chat_id)
        data = msg + '\n' + fn + ' ' + ln + ' (https://staff.yandex-team.ru/' + login + ')\n @' + tg_login
        logging.info("request: %s, data: %s, headers: %s", r, data, headers)
        result = requests.post(r, json={"text": data}, headers=headers)
        if result.status_code != 200:
            logging.error("Error send to nyanbot %s and returned %d", result.content, result.status_code)
            return "", False
    except requests.RequestException as error:
        logging.error("Error occured while sending to nyanbot: '%s'.", error)
        return "", False
    logging.info("Send to nyanbot is successfuly")
    return result.text, True
