# -*- coding: utf-8 -*-
import logging

import sandbox.common as common
import sandbox.sdk2 as sdk2


logger = logging.getLogger(__name__)


def get_sentry_dsn(task_obj):
    env_to_sentry_secret = {
        'TESTING': 'AVIA_SENTRY_TESTING_DSN',
        'PRODUCTION': 'AVIA_SENTRY_PRODUCTION_DSN',
    }
    for env, secret_name in env_to_sentry_secret.iteritems():
        if env in task_obj.Parameters.tags:
            try:
                sentry_dsn = sdk2.Vault.data(task_obj.Parameters.vaults_owner, secret_name)
            except AttributeError:
                sentry_dsn = None
                logger.warning('No "vaults_owner" in task parameters.', exc_info=True)
            except common.errors.VaultError:
                sentry_dsn = None
                logger.warning(
                    'Cannot get sentry DSN from sandbox vault for key %s.',
                    secret_name,
                    exc_info=True,
                )
            break
    else:
        sentry_dsn = None
        logger.warning(
            'Unable to detect sentry DSN from environment type. No suitable tag %s provided.',
            env_to_sentry_secret.keys(),
        )

    return sentry_dsn


def configure_logging(sentry_dsn=None):
    if sentry_dsn:
        import raven
        from raven.handlers.logging import SentryHandler

        client = raven.Client(sentry_dsn)
        handler = SentryHandler(client)
        handler.setLevel(logging.ERROR)
        raven.setup_logging(handler)


def remove_secrets(params_dict):
    """
    Скрываем чувствительные данные в словаре

    :param dict[str, str] params_dict: словарь с данными
    :return:
    """
    cp = params_dict.copy()
    secret_keys = ['password', 'passwd', 'hash']
    for key in secret_keys:
        if key in cp:
            cp[key] = '*' * len(cp[key])
    return cp
