# -*- coding: utf-8 -*-

import logging

from sandbox.projects.common.vcs.arc import Arc
from sandbox.projects.trendbox_ci.beta.managers.arc.arc_apply import ArcApplyToolEnvironment


def create_arc_context(mount_point, store_path, commit=None, object_store_path=None):
    ArcApplyToolEnvironment().prepare()

    logging.debug('Mounting Arc')
    mount_point.mkdir(parents=True, exist_ok=True)
    store_path.mkdir(parents=True, exist_ok=True)

    mount_params = dict(
        path=None,
        changeset=commit,
        mount_point=str(mount_point),
        store_path=str(store_path),
        object_store_path=object_store_path,
        allow_root=True,
        fetch_all=False
    )

    logging.debug('Arc mount parameters: {}'.format(mount_params))
    return Arc().mount_path(**mount_params)


# To call in on_prepare
def prepare_arc_environments():
    ArcApplyToolEnvironment().prepare()
