# -*- coding: utf-8 -*-
import logging
import json
import uuid

from sandbox.common.utils import get_task_link
from sandbox.projects.trendbox_ci.beta.modules import SandboxEncoder
from sandbox.projects.trendbox_ci.beta.modules.request import send_request


class WebHookManager(object):
    """
    Manager that helps to send data to services.
    """

    def __init__(self, task):
        """
        :param task: Task instance.
        :type task: sdk2.Task
        """
        self.task = task

    def payload(self, status):
        """
        :param status: статус задачи
        :type status: str
        :rtype: str
        """
        ctx = self.task.Context.__getstate__()
        params = self.task.Parameters.__getstate__()

        payload = {
            'id': self.task.id,
            'url': get_task_link(self.task.id),
            'status': status,
            'type': self.task.type.name,
            'context': ctx
        }

        payload.update(params)

        return json.dumps(payload, cls=SandboxEncoder)

    @staticmethod
    def send_post(url, data):
        """
        :param url: URL для отправки payload-а
        :type url: str
        :param data: payload
        :type data: str
        :rtype: dict
        """
        request_id = str(uuid.uuid4())

        try:
            res = send_request(
                "post",
                url,
                headers={
                    'Content-Type': 'application/json',
                    'X-Request-Id': request_id
                },
                data=data,
                verify=False
            )

            logging.debug(u'response for {url} (request id {request_id}) with code {code} is: {text}'.format(
                url=url,
                request_id=request_id,
                code=res.status_code,
                text=res.text
            ))

            return res
        except Exception as error:
            logging.exception('request to {url} (request id {request_id}) failed with {error}'.format(
                url=url,
                request_id=request_id,
                error=error
            ))

    def send(self, status, urls):
        """
        :param status: статус задачи
        :type status: str
        :param urls: URL-ы для отправки payload-а
        :type urls: list of str
        """
        payload = self.payload(status)

        if payload:
            logging.debug('payload: {}'.format(payload))

            for url in urls:
                self.send_post(url, payload)
        else:
            logging.debug('payload is empty')
