# -*- coding: utf-8 -*-

import json
import tempfile
import os


def dump_json(data, filename='data.json'):
    """
    :param data: data
    :type data: dict
    :param filename: name of temp file.
    :type filename: str
    """
    tempdir = tempfile.mkdtemp()
    path = os.path.join(tempdir, filename)

    with open(path, 'w') as outfile:
        json.dump(data, outfile)

    return path
