# -*- coding: utf-8 -*-

import logging

from sandbox.projects.trendbox_ci.beta.constants.net import YANDEX_NETWORK
from sandbox.projects.trendbox_ci.beta.modules.process import run_process


# Drop all requests, except internal yandex network
def isolate_container(task):
    logging.debug('isolating container')

    # isolation all outgoing requests not to yandex network is also blocks loopback requests
    # see FEI-24920, TVANDROID-5850
    run_process(
        task=task,
        process_name='isolate',
        cmd='ip6tables --append INPUT --in-interface lo --jump ACCEPT'
    )
    run_process(
        task=task,
        process_name='isolate',
        cmd='ip6tables --append OUTPUT --out-interface lo --jump ACCEPT'
    )

    run_process(
        task=task,
        process_name='isolate',
        cmd=u'ip6tables --append OUTPUT ! --destination \'{net}\' --jump DROP'.format(  # nopep8
            net=YANDEX_NETWORK,
        )
    )
