# -*- coding: utf-8 -*-


def get_subtasks(task):
    """
    Returns task's list of subtasks

    :param task: TRENDBOX_CI_JOB task
    :type task: sandbox.sdk2.Task
    :rtype: sandbox.sdk2.Task[]
    """
    ids = task.Context.subtasks_ids
    count = len(ids)

    return list(task.find(None, id=ids).limit(count))


def create_subtask(task, task_type, **parameters):
    """
    Create job and add it id in parent task's Context

    :param task: TRENDBOX_CI_JOB task
    :type task: sandbox.sdk2.Task
    :param task_type: Tasks constructor
    :type task_type: sandbox.sdk2.Task
    :param **parameters: Parameters
    """
    subtask = task_type(task, **parameters)
    task.Context.subtasks_ids.append(subtask.id)

    return subtask


__all__ = [
    get_subtasks,
    create_subtask,
]
