# -*- coding: utf-8 -*-
import logging

from sandbox import sdk2
from sandbox.common.types import resource as ctr
from sandbox.common.utils import classproperty


class LastResource(sdk2.parameters.Resource):
    """Last resource by default for input parameters"""

    owner = None  # Enable `owner` keyword argument

    @classmethod
    def get_custom_parameters(cls):
        """
        :return: default attrs in resource finder popup
        :rtype: dict
        """
        return {
            'resource_type': cls.resource_type,
            'owner': cls.owner,
            'attrs': cls.attrs,
        }

    @classproperty
    def default_value(cls):
        """
        :return: last resource by custom attrs
        :rtype: sdk2.Resource or None
        """
        try:
            params = dict(
                type=cls.resource_type,
                owner=cls.owner,
                attrs=cls.attrs,
                state=ctr.State.READY,
            )

            resource = sdk2.Resource.find(**params).order(-sdk2.Resource.id).first()

            return resource if resource else None
        except LookupError as er:
            logging.exception('Error while loading resource: {}'.format(er.message))

            return None
