# -*- coding: utf-8 -*-
import json


class SandboxEncoder(json.JSONEncoder):
    """
    Конвертирует Object в JSON
    У task.Parameters и task.Context есть реализация метода __getstate__,
    который возвращает информацию в виде tuple в дальнейшем сеализируемый в JSON.
    Данный класс нужен для кастомного преобразования, если же мы будем использовать JSONDecoder (по умолчанию),
    то получим ошибки вида "... is not JSON serializable"
    https://docs.python.org/2/library/json.html
    """

    def default(self, o):
        if hasattr(o, "__getstate__"):
            return o.__getstate__()
        return super(SandboxEncoder, self).default(o)
