# -*- coding: utf-8 -*-
import logging
import json

from sandbox.projects.trendbox_ci.beta.modules import SandboxEncoder


def serialize_task(task):
    """
    :param task: Task instance
    :type task: sdk2.Task
    :return: task info
    :rtype: dict
    """
    data = _serialize_task(task)
    return json.dumps(data, cls=SandboxEncoder)


def _serialize_task(task):
    """
    :param task: Task instance
    :type task: sdk2.Task
    :return: task info
    :rtype: dict
    """
    logging.debug('serializing {}'.format(task))

    try:
        log_path = str(task.log_path())
    except Exception:
        log_path = None

    data = dict(
        id=task.id,
        parent_task=_serialize_task(task.parent) if task.parent else None,
        type=task.type.name,
        status=task.status,
        author=task.author,
        owner=task.owner,
        host=task.host,
        hidden=task.hidden,
        created=task.created.isoformat() if task.created else None,
        updated=task.updated.isoformat() if task.updated else None,
        parameters=task.Parameters.__getstate__(),
        requirements=task.Requirements.__getstate__(),
        context=task.Context.__getstate__(),
        info=task.info,
        log_resource=_serialize_resource(task.log_resource) if task.log_resource else None,
        working_path=str(task.path()),
        log_path=log_path,
        synchrophazotron_path=str(task.synchrophazotron),
        arcaphazotron_path=str(task.arcaphazotron),
    )

    logging.debug('serialized {}: {}'.format(task, data))

    return data


def _serialize_resource(resource):
    """
    :param resource: Resource instance
    :type resource: sdk2.Resource
    :return: resource info
    :rtype: dict
    """
    logging.debug('serializing {}'.format(resource))

    data = dict(
        id=resource.id,
        type=resource.type.name,
        path=str(resource.path),
        description=resource.description,
        owner=resource.owner,
        task_id=resource.task_id,
        state=resource.state,
        arch=resource.arch,
        created=resource.created.isoformat() if resource.created else None,
        accessed=resource.accessed.isoformat() if resource.accessed else None,
        expires=resource.expires.isoformat() if resource.expires else None,
        client=resource.client,
        size=resource.size,
        skynet_id=resource.skynet_id,
        md5=resource.md5,
        rights=resource.rights,
        url=resource.url,
        http_proxy=resource.http_proxy,
        releaseable=resource.releasable,
        any_arch=resource.any_arch,
        executable=resource.executable,
        auto_backup=resource.auto_backup,
        calc_md5=resource.calc_md5,
        deprecated=resource.deprecated,
        releasers=resource.releasers,
        release_subscribers=resource.release_subscribers,
        share=resource.share,
        ttl=resource.ttl,
        released=resource.released,
        backup_task=resource.backup_task,
        mds=resource.mds,
        from_task=resource.from_task,
    )

    logging.debug('serialized {}: {}'.format(resource, data))

    return data
