# -*- coding: utf-8 -*-

import logging
import tarfile


def unpack_tar(from_path, dest_path):
    """
    :param from_path: path to archive.
    :type from_path: pathlib2.Path|str
    :param dest_path: path for extracting.
    :type dest_path: pathlib2.Path|str
    """
    from_path = str(from_path)
    dest_path = str(dest_path)

    with tarfile.open(from_path, mode='r:*') as tar:
        logging.debug('Unpacking "{from_path}" to "{dest_path}"'.format(from_path=from_path, dest_path=dest_path))

        tar.extractall(dest_path)
