#!/usr/bin/env bash
set -ex

tmpfs_size="1G"

# To be able to use overlay2 storage
mkdir -p /var/lib/docker
cat <<EOF >> /etc/fstab
none /var/lib/docker tmpfs rw,relatime,size=30G 0 0
EOF

# Install deps for Trendbox CI
apt-get update
apt-get install -y git software-properties-common expect

# Install ansible
add-apt-repository ppa:ansible/ansible
apt_conf=/etc/apt/preferences.d/ansible-ppa-pin-1500
cat <<EOF > $apt_conf
Package: ansible
Pin: release o=LP-PPA-ansible-ansible
Pin-Priority: 1500
EOF
DEBIAN_FRONTEND=noninteractive apt-get update --yes || (sleep 15; apt-get update --yes)
apt-cache policy ansible
DEBIAN_FRONTEND=noninteractive apt-get install --yes ansible=2.9.*

# Clone Trendbox CI repository
git clone https://github.yandex-team.ru/search-interfaces/trendbox-ci.git && cd trendbox-ci/containers/sandbox-cloud/lxc
git fetch && git checkout __PLACE_FOR_TRENDBOX_BRANCH__

# Ansible configuration
cat <<EOF > trendbox-ci.yml
__PLACE_FOR_ANSIBLE_SCRIPT__
EOF

# Run ansible
ansible-playbook trendbox-ci.yml -vvv -e '__PLACE_FOR_EXTRA_VARS__'

# Clean things up
apt-get autoremove --yes software-properties-common expect ansible
