# -*- coding: utf-8 -*-

from sandbox.common.types import task as ctt
from sandbox.common.types import resource as ctr


class ReportsManager(object):
    """
    Reports collection.
    """

    def __init__(self, task):
        """
        :param task: Sandbox task instance.
        """
        self.task = task

    @staticmethod
    def status_badge(status):
        """
        Return HTML to display specified status.
        :param status: Status to display.
        :return: HTML string.
        """
        status_badge = {
            ctt.Status.SUCCESS: '<span class="status status_success">success</span>',
            ctt.Status.FAILURE: '<span class="status status_failure">failure</span>',
            ctr.State.BROKEN: '<span class="status status_broken">broken</span>',
        }
        return status_badge[status]

    @staticmethod
    def description(url, report_title, main_path):
        url = '{}/{}'.format(url, main_path) if main_path else url

        return'<a href="{url}" target="_blank">{text}</a>'.format(url=url, text=report_title)

    def lifelines_link(self):
        url = 'https://lifelines.si.yandex-team.ru/task/{}'.format(self.task.id)
        link = '<a href="{}" target="_blank">Lifelines</a>'.format(url)
        return {'<h3>Task flow</h3>': link}

    def reports(self, reports):
        """
        Table with links to the reports.
        :return: Report object.
        """
        items = []

        for report in reports:
            report_id = report['id']
            report_info = self.task.server.resource[report_id].read()
            report_url = report_info['http']['proxy']
            report_status = report_info['attributes']['status']
            # see https://st.yandex-team.ru/FEI-4998
            if report_info['state'] == ctr.State.BROKEN:
                report_status = ctr.State.BROKEN
            main_path = report.get('main', None)
            report_title = report.get('title', None)

            items.append({
                'Status': self.status_badge(report_status),
                'Report': self.description(report_url, report_title, main_path),
            })

        return {'<h3 id="checks-reports">Checks reports</h3>': items}
