# -*- coding: utf-8 -*-
import logging
import requests
import json

from sandbox.common.utils import get_task_link
from sandbox.projects.trendbox_ci.stable.modules import SandboxEncoder


class WebHookManager(object):
    """
    Manager that helps to send data to services.
    """

    def __init__(self, task):
        """
        :param task: Task instance.
        :type task: sdk2.Task
        """
        self.task = task

    def payload(self, status):
        """
        :param status: статус задачи
        :type status: str
        :rtype: str
        """
        ctx = self.task.Context.__getstate__()
        params = self.task.Parameters.__getstate__()

        payload = {
            'id': self.task.id,
            'url': get_task_link(self.task.id),
            'status': status,
            'type': self.task.type.name,
            'context': ctx
        }

        payload.update(params)

        return json.dumps(payload, cls=SandboxEncoder)

    @staticmethod
    def send_post(url, data):
        """
        :param url: URL для отправки payload-а
        :type url: str
        :param data: payload
        :type data: str
        :rtype: dict
        """
        try:
            res = requests.post(
                url,
                headers={'Content-Type': 'application/json'},
                data=data,
                verify=False
            )

            logging.debug('response for {url} with code {code} is: {text}'.format(
                url=url,
                code=res.status_code,
                text=res.text
            ))

            return res
        except Exception as error:
            logging.exception('request to {url} failed with {error}'.format(
                url=url,
                error=error
            ))

    def send(self, status, urls):
        """
        :param status: статус задачи
        :type status: str
        :param urls: URL-ы для отправки payload-а
        :type urls: list of str
        """
        payload = self.payload(status)

        if payload:
            logging.debug('payload: {}'.format(payload))

            for url in urls:
                self.send_post(url, payload)
        else:
            logging.debug('payload is empty')
