# list of TRENDBOX_CI_JOB schedulers id's (except deleted) on 20 april 2022
TRENDBOX_CI_JOB_ALLOWED_SCHEDULERS = [
    710169, 710168, 709940, 709382, 707608, 705386, 705385, 705006, 705002, 704884,
    704371, 702710, 702005, 702004, 701950, 701949, 701928, 701927, 700776, 700743,
    700722, 698987, 698864, 698840, 698748, 698685, 698460, 698459, 698408, 698407,
    698392, 698096, 698094, 698072, 697945, 697924, 697923, 697881, 697837, 697552,
    697536, 697534, 697435, 696992, 696876, 696604, 696560, 696553, 696552, 696550,
    696540, 696167, 696116, 695725, 559037, 551013, 550588, 540120, 478911, 274234,
    266770, 265773, 83105, 82554, 54796, 54147, 45218, 45216, 45094, 44976,
    44975, 44974, 44956, 44954, 44852, 44827, 44802, 44793, 44791, 44767,
    44631, 44628, 44555, 44551, 44494, 44430, 44429, 44251, 44249, 44099,
    43997, 43737, 43715, 43714, 43700, 43695, 43579, 43536, 43535, 43518,
    43517, 43355, 43207, 42606, 26569, 25318, 25310, 25309, 25206, 25169,
    25124, 25089, 24479, 24478, 24477, 24476, 24475, 24474, 24240, 24239,
    23695, 23587, 23500, 23499, 23101, 23100, 22970, 22969, 22664, 22649,
    22466, 22198, 22142, 22127, 22121, 22100, 22056, 22055, 22054, 21966,
    21799, 21580, 21541, 21540, 21539, 21503, 21502, 21493, 21492, 21491,
    21481, 21466, 21385, 21350, 21328, 21000, 20966, 20802, 20789, 20788,
    20787, 20472, 20404, 20093, 20068, 20067, 20006, 19927, 19866, 19616,
    19606, 19513, 19510, 19388, 19198, 19186, 19173, 19058, 19000, 18968,
    18935, 18903, 18867, 18866, 18857, 18845, 18822, 18540, 18480, 18469,
    18459, 18429, 18397, 18355, 18342, 18251, 18250, 18139, 18102, 18086,
    18082, 18081, 18052, 18051, 18050, 18042, 18034, 18009, 17982, 17981,
    17914, 17890, 17846, 17840, 17726, 17594, 17577, 17559, 17554, 17547,
    17518, 17505, 17337, 17245, 17103, 17076, 17075, 17047, 17031, 17012,
    17011, 16824, 16814, 16810, 16311, 16308, 16201, 16200, 16110, 15852,
    15836, 15835, 15834, 15817, 15772, 15758, 15731, 15654, 15581, 15544,
    15543, 15542, 15541, 15539, 15410, 15409, 15407, 15319, 15311, 15197,
    15164, 15153, 15150, 14874, 14686, 14625, 14563, 14528, 14525, 14524,
    14443, 14414, 14358, 14339, 14325, 14324, 14323, 14322, 14266, 14172,
    14165, 14164, 13898, 13787, 13491, 13401, 13127, 13069, 13050, 12604,
    12549, 12548, 12484, 12435, 12185, 11964, 11945, 11939, 11782, 11275,
    10899, 10656, 10593, 10305, 9796, 9412, 9286, 9270, 9269, 8518,
    8484, 8483, 8464, 8463, 8461, 8460, 8354, 8353, 7904, 6977,
    6935, 6820, 6815, 6768, 6764, 6589, 6588, 6587, 6586, 6583, 6302,
    6254, 6088, 6082, 6078
]

# @see INFRADUTY-22481 TRENDBOX-1171
TRENDBOX_CI_JOB_WHITELIST = [
    "TOLOKA_FRONT_DEV"
]


def is_scheduler_allowed_to_run(task):
    # abs(task.scheduler) is correct way to define scheduler id, see DEVTOOLSSUPPORT-16581
    return abs(task.scheduler) in TRENDBOX_CI_JOB_ALLOWED_SCHEDULERS


def is_task_able_to_run(task):
    return task.owner in TRENDBOX_CI_JOB_WHITELIST
