# -*- coding: utf-8 -*-
from sandbox import sdk2

from sandbox.projects.sandbox.resources import LXC_CONTAINER

from sandbox.projects.trendbox_ci.team import TRENDBOX_TEAM


class TRENDBOX_CI_LXC_IMAGE(LXC_CONTAINER):
    """
        Tarball with TrendBox CI LXC image
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = TRENDBOX_TEAM
    release_subscribers = TRENDBOX_TEAM


class TRENDBOX_CI_RESOURCE(sdk2.Resource):
    """
        Trendbox CI resource
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = False
    any_arch = True
    executable = False
    auto_backup = True


class TRENDBOX_CI_REPORT_RESOURCE(sdk2.Resource):
    """
        Trendbox CI resource with report
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = False
    any_arch = True
    executable = False
    auto_backup = True
