# -*- coding: utf-8 -*-

from sandbox import sdk2


class RefreshReleaseMetrics(sdk2.Task):
    class Parameters(sdk2.Parameters):
        conductor_token = sdk2.parameters.YavSecret('Yav secret for conductor token', required=True)
        teamcity_token = sdk2.parameters.YavSecret('Yav secret for teamcity token', required=True)
        ydb_token = sdk2.parameters.YavSecret('Yav secret for ydb token', required=True)
        binary_resource_id = sdk2.parameters.Integer('release metrics binary', required=True)

    def on_execute(self):
        env = {
            'CONDUCTOR_TOKEN': self.Parameters.conductor_token.data()['CONDUCTOR_TOKEN'],
            'TEAMCITY_TOKEN': self.Parameters.teamcity_token.data()['TEAMCITY_TOKEN'],
            'YDB_TOKEN': self.Parameters.ydb_token.data()['YDB_TOKEN'],
        }
        resource = sdk2.Resource[self.Parameters.binary_resource_id]
        data = sdk2.ResourceData(resource)
        with sdk2.helpers.ProcessLog(self, logger="shell") as pl:
            sdk2.helpers.subprocess.check_call(
                [str(data.path)],
                stdout=pl.stdout, stderr=pl.stderr,
                env=env,
            )
