# -*- coding: utf-8 -*-
import logging

import sandbox.sandboxsdk.environments as sdk_environments

from sandbox import sdk2

from sandbox.projects.ads.tsar.lib import convert_resource_to_sthash_dump
# from sandbox.projects.ads.tsar.lib import make_difacto_dump

from sandbox.projects.adv_machine.common import ConfigFormat, upload_file_to_yt, get_yt_config
from sandbox.projects.adv_machine.common.parameters import YTParameters

logger = logging.getLogger(__name__)


class UploadTsarFfmToYt(sdk2.Task):
    """Collects ffm dumps from several task_ids and pushes it into //home/advquality/tsar/tsar_models/ffm"""
    class Requirements(sdk2.Task.Requirements):
        cores = 1

        environments = [
            sdk_environments.PipEnvironment('yandex-yt'),
            sdk_environments.PipEnvironment('yandex-yt-yson-bindings-skynet', version='0.3.32-0'),
        ]

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        yt_params = YTParameters
        resources = sdk2.parameters.Dict("List of ffm resources and task_names (dmlc dumps)")
        dumps_dir_name = sdk2.parameters.String("Name of directory with dumps", default_value="tsar_difacto_models")
        yt_prefix = sdk2.parameters.String("Yt Prefix", default_value="//home/advquality/tsar/tsar_models/ffm")
        attribute_name = sdk2.parameters.String("Attribute Name", default_value="@sandbox_resource_id")

    def _upload_ffm_dump_on_yt(self, yt, yt_client, yt_path, dump_path, resource_id, attribute_name):
        logger.info('Upload %s to %s' % (dump_path, yt_path))
        upload_file_to_yt(yt_client, yt_path, dump_path)
        yt_client.set(yt.ypath_join(yt_path, attribute_name), str(resource_id))

    def _upload_dumps_on_yt(self):
        adv_yt_config = get_yt_config(self.Parameters.yt_params, self.author, format=ConfigFormat.CLIENT)

        import yt.wrapper as yt
        yt_client = yt.YtClient(config=adv_yt_config)

        for resource_id, task_id in self.Parameters.resources.iteritems():
            resource = sdk2.Resource.find(id=resource_id).first()
            tsar_dump_path = task_id
            logging.info('Found dump {}'.format(tsar_dump_path))
            convert_resource_to_sthash_dump(
                resource,
                tsar_dump_path,
                compression_type='float',
                model_format='sthash'
            )

            yt_path = yt.ypath_join(self.Parameters.yt_prefix, tsar_dump_path)
            self._upload_ffm_dump_on_yt(
                yt=yt,
                yt_client=yt_client,
                yt_path=yt_path,
                dump_path=tsar_dump_path,
                resource_id=resource_id,
                attribute_name=self.Parameters.attribute_name
            )

    def on_execute(self):
        if not self.Parameters.resources:
            logger.info("No dump resources provided - nothing to do")
            return

        self._upload_dumps_on_yt()
