# coding: utf-8

from sandbox import sdk2
from sandbox.sandboxsdk import process
from sandbox.projects.turbo import resources
from sandbox.sandboxsdk.environments import PipEnvironment
from sandbox.projects.common.search import bugbanner2
from sandbox.projects.common import error_handlers as eh

URL_TEMPLATE = (
    "https://yandex.ru/search/news-cache/touch?{}&json_dump=eventlog"
    "&srcrwr=APP_HOST:vla1-0053.search.yandex.net:32335"
    "&app_host_path=news-cache=/_ctx/_json/_dbg/turbopages_test3"
)


class SampleForTurbo(bugbanner2.BugBannerTask):

    class Requirements(sdk2.Requirements):
        environments = [
            PipEnvironment('yandex-yt', use_wheel=True),
            PipEnvironment('yandex-yt-yson-bindings-skynet', use_wheel=True)
        ]

    class Parameters(sdk2.Task.Parameters):
        date = sdk2.parameters.String("Table date", required=True)
        make_ammo = sdk2.parameters.Resource(
            "make_tank_ammo executable",
            # resourse_type=app_host_resources.APP_HOST_TOOL_MAKE_TANK_AMMO_EXECUTABLE,  # FIXME: invalid argument (SANDBOX-6404)
            required=True,
        )
        jq = sdk2.parameters.Resource(
            "jq executable",
            # resourse_type=resource_types.JQ_EXECUTABLE,  # FIXME: invalid argument (SANDBOX-6404)
            required=True,
        )
        count = sdk2.parameters.Integer("Number of queries: ", default=1000, required=True)
        used_for_testenv = sdk2.parameters.Bool("Mark if use for testenv update", default=False)

    def on_execute(self):

        self.add_bugbanner(bugbanner2.Banners.Turbo)

        from yt.wrapper import YtClient

        token = sdk2.Vault.data("prs_ops_yt_test")
        client = YtClient("hahn", token)

        try:
            table = client.read_table(
                "//logs/yandex-access-log/30min/{}".format(self.Parameters.date)
            )
        except Exception:
            eh.check_failed("Cannot read //logs/yandex-access-log/30min/{}".format(self.Parameters.date))

        turbo_plan_tmp = resources.TURBO_PLAN(
            self,
            "turbo_plan_tmp",
            "turbo_plan_tmp",
            auto_update=False,
        )

        turbo_plan_path_tmp = str(sdk2.ResourceData(turbo_plan_tmp).path)

        turbo_plan = resources.TURBO_PLAN(
            self,
            "turbo_plan",
            "turbo_plan_{}.txt".format(self.Parameters.date),
            auto_update=self.Parameters.used_for_testenv,
        )

        turbo_plan_path = str(sdk2.ResourceData(turbo_plan).path)

        count = 0

        for line in table:
            if "/turbo?" in line["request"]:
                count += 1

                url = URL_TEMPLATE.format(line["request"][7:])
                cmd_line = (
                    'curl "{}"| {} .eventlog -r | grep -P "TSourceRequest\tTURBO_MERGER" | head -1 | '
                    'sed "s/^[0-9]\+\t[0-9]\tTSourceRequest\tTURBO_MERGER\t//" >> {}'.format(
                        url,
                        str(sdk2.ResourceData(self.Parameters.jq).path),
                        turbo_plan_path_tmp,
                    )
                )
                process.run_process(cmd_line, shell=True)

                if count > self.Parameters.count:
                    break

        if count < self.Parameters.count:
            eh.check_failed("Got {} requests, expected {}".format(count, self.Parameters.count))

        sdk2.ResourceData(turbo_plan_tmp).ready()

        process.run_process("{} -i {} -o {}".format(
            str(sdk2.ResourceData(self.Parameters.make_ammo).path),
            turbo_plan_path_tmp,
            turbo_plan_path,
        ), shell=True)
        sdk2.ResourceData(turbo_plan).ready()
