# coding: utf-8
import os
import json
import urllib

from sandbox import sdk2
from sandbox.sandboxsdk import svn
from sandbox.projects.turbo import resources
from sandbox.sandboxsdk.environments import PipEnvironment
from sandbox.projects.common.search import bugbanner2


class SampleForTurboQueries(bugbanner2.BugBannerTask):
    class Requirements(sdk2.Requirements):
        environments = [
            PipEnvironment('yandex-yt', use_wheel=True),
            PipEnvironment('yandex-yt-yson-bindings-skynet', use_wheel=True)
        ]

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 6 * 3600
        date = sdk2.parameters.String("Table date", required=True)
        sampled_turbo_keys_table = sdk2.parameters.String('Sample turbo keys table', default='//home/turborss/runtime_tests/turbo_keys', required=True)
        yt_proxy = sdk2.parameters.String('Yt proxy', default='hahn')
        used_for_testenv = sdk2.parameters.Bool("Mark if use for testenv update", default=False)

    def on_execute(self):
        from yt.wrapper import YtClient

        yt_client = YtClient(
            proxy=self.Parameters.yt_proxy,
            token=sdk2.Vault.data("prs_ops_yt_test")
        )

        self.add_bugbanner(bugbanner2.Banners.Turbo)

        turbo_queries = resources.TURBO_QUERIES(
            self,
            "turbo_queries_{}".format(self.Parameters.date),
            "turbo_queries_{}".format(self.Parameters.date),
            auto_update=self.Parameters.used_for_testenv,
        )
        turbo_queries_path = str(sdk2.ResourceData(turbo_queries).path)

        items = []
        always_add = os.path.abspath("empty_requests.urls")
        svn.Arcadia.export(
            "arcadia:/arc/trunk/arcadia/quality/functionality/turbo/runtime/sandbox_tests/files/empty_requests.urls",
            always_add
        )
        with open(always_add, "r") as ff:
            for req in ff:
                items.append(
                    {
                        'url_path': req[req.find("/turbo"):],
                        'platform': 'touch',
                    }
                )

        for row in yt_client.read_table(self.Parameters.sampled_turbo_keys_table):
            turbo_key = row['key']
            url_paths = [
                '/turbo?text={turbo_key}&no_rand_for_tests=1'.format(
                    turbo_key=urllib.quote_plus(turbo_key.encode('utf8'))
                )
            ]
            if '/yandexturbocatalog/' in turbo_key:
                # Add shop main page.
                url_paths.append(
                    '%s&page_type=main&ecommerce_main_page_preview=1' % url_paths[0]
                )
            for url_path in url_paths:
                items.append(
                    {
                        'url_path': url_path,
                        'platform': row.get('platform', 'touch'),
                    }
                )

        with open(turbo_queries_path, "w") as f:
            f.write(json.dumps(items))

        sdk2.ResourceData(turbo_queries).ready()
