from os.path import join as pj
import json
import logging
from sandbox import sdk2
from sandbox.sandboxsdk import environments


class UploadTurboOwnersToYt(sdk2.Task):
    """
    Upload turbo owners from config to yt directory
    """

    class Requirements(sdk2.Task.Requirements):
        disk_space = 1024  # 1GB

        environments = [
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet'),
        ]

    class Parameters(sdk2.Parameters):
        yt_server = sdk2.parameters.String("Yt server name", default='hahn')
        yt_path = sdk2.parameters.String("Path to destination directory", default='//home/content_plugins/full_owners_list')

    def _checkout_configs(self):
        svn_url = 'arcadia:/arc/trunk/arcadia/quality/functionality/content_plugins/configs/'
        return sdk2.svn.Arcadia.get_arcadia_src_dir(svn_url)

    def _cut_paths(self, host):
        res = host.split('/')[0]
        return res

    def on_execute(self):
        configs_dir = self._checkout_configs()
        owners = set()

        for subdir in ['exported_hosts']:
            metadata = json.loads(open(pj(configs_dir, subdir, 'metadata.json'), 'r').read())
            for item in metadata:
                if not item.get("turbo_autoparser"):
                    continue
                for subitem in item['hosts']:
                    if 'list_file' in subitem:
                        file_name = subitem['list_file']
                        file_path = pj(configs_dir, subdir, file_name)
                        owners.update([self._cut_paths(host) for host in open(file_path, 'r').read().split() if host])
                    else:
                        owners.update([self._cut_paths(host) for host in subitem['list']])

        logging.debug('Owners list: %s', ' '.join(owners))

        import yt.wrapper as yt
        token = sdk2.Vault.data("TURBO_YT_TOKEN")
        cli = yt.YtClient(self.Parameters.yt_server, token=token)
        cli.write_table(self.Parameters.yt_path, [{'owner': owner} for owner in owners])
