from sandbox import sdk2


TURBO_RELEASERS_LIST = [
    "stasd07",
    "shubert",
    "ilyakuchumov",
    "web-chib",
    "nshal",
    "egorshelk",
    "bogolubsky",
    "sagishev",
    "pzuev",
    "alexbuchkin",
    "starcev",
    "nkireev",
    "nik-lozhkarev",
    "robot-srch-releaser",
    "mhuman",
    "ngolichenko",
    "alexander-tr",
    "arapova",
    "diigl",
    "gershgorin",
    "robot-morty",
    "mihailgribov",
    "lokehoke",
    "kogutivan",
    "romariogi",
]


class TURBO_EXECUTABLE(sdk2.Resource):
    """
        turbo binary
    """
    any_arch = False
    executable = True
    releasable = True
    auto_backup = True
    arcadia_build_path = "quality/functionality/turbo/merger/turbo_merger"


class TURBO_PLAN(sdk2.Resource):
    """
        turbo plan
    """
    any_arch = False
    executable = False
    releasable = False
    auto_update = sdk2.parameters.Bool("auto_update")


class TURBO_CONFIG(sdk2.Resource):
    """
        turbo config
    """
    any_arch = False
    executable = False
    releasable = False


class TURBO_QUERIES(sdk2.Resource):
    """
        turbo query
    """
    any_arch = False
    executable = False
    releasable = False
    auto_update = sdk2.parameters.Bool("auto_update")


class TURBO_DIFF(sdk2.Resource):
    """
        turbo diffs
    """
    any_arch = False
    executable = False
    releasable = False


class TURBO_MERGER_PACKAGE(sdk2.Resource):

    auto_backup = True
    releasable = True
    releasers = TURBO_RELEASERS_LIST


class TURBO_INIT_PACKAGE(sdk2.Resource):

    auto_backup = True
    releasable = True
    releasers = TURBO_RELEASERS_LIST


class TURBO_DDM_PACKAGE(sdk2.Resource):

    auto_backup = True
    releasable = True
    releasers = TURBO_RELEASERS_LIST


class TURBO_PARSER_STDOUT(sdk2.Resource):
    """
        Turbo parser binary stdout
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True


class TURBO_PARSER_STDERR(sdk2.Resource):
    """
        Turbo parser binary stderr
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True


class TURBO_MERGER_ADS_MODELS(sdk2.Resource):
    """
        Catboost models for ads arrangement in turbo merger
    """
    auto_backup = True
    releasable = True
    releasers = TURBO_RELEASERS_LIST
