# encoding: utf-8
from __future__ import unicode_literals

from sandbox import sdk2

from sandbox.common import errors
from sandbox.projects.tutorial import common as tutorial_common


class HelloKoshdm(sdk2.Task):

    class Requirements(sdk2.Requirements):
        disk_space = 100  # MiB
        ram = 1024  # MiB
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            """ No caches required """

    class Parameters(sdk2.Parameters):
        # Common parameters
        kill_timeout = 5 * 60  # seconds
        description = "Create a greeting for someone"

        # Input parameters
        login = sdk2.parameters.String("Login of the person you want to greet", default="koshdm", required=True)
        create_html = sdk2.parameters.Bool("Make HTML version", default=False)

        # Output parameters
        with sdk2.parameters.Output:
            result = sdk2.parameters.Resource("Resource with the greetings", resource_type=tutorial_common.Greeting)

    # -------------------------------------------------------------------------
    # Server-side methods

    def on_enqueue(self):
        self.Parameters.description = "Create a greeting for {}".format(self.Parameters.login)

    # -------------------------------------------------------------------------
    # Client-side methods

    def on_execute(self):

        if self.Parameters.create_html:
            raise errors.TaskFailure("HTML greeting is not implemented yet!")

        resource = tutorial_common.Greeting(
            self,
            description="Created by Sandbox task #{}".format(self.id),
            path="hello.md",
        )

        resource_data = sdk2.ResourceData(resource)

        text = (
            "# Hello, {}!\n\n"
            "Thanks for using Sandbox!"
            .format(self.Parameters.login)
        )
        with resource_data.path.open("w") as f:
            f.write(text)

        resource_data.ready()

        if not self.Parameters.result:
            self.Parameters.result = resource
