import logging

from sandbox.projects.tv.target_check.common.utils import read_file, generate_head_for_html_report, convert_logo_image


def get_property_from_file(searched_property, config):
    logging.info(">>> search property in file - {}".format(searched_property))
    if config is None:
        return None

    for line in config.splitlines():
        if searched_property + "=" in line:
            return line.rsplit("=", 1)[1].rstrip()
    else:
        logging.info("Unable to find property {}".format(searched_property))
        return None


def get_properties(resource_path, properties_keys_list, result_path):
    platform_build_props = read_file("{}/platform_build.prop".format(resource_path))
    system_build_props = read_file("{}/system_build.prop".format(resource_path))
    vendor_build_props = read_file("{}/vendor_build.prop".format(resource_path))
    all_build_props = platform_build_props + vendor_build_props + system_build_props

    properties = {"clids": {}, "product_props": {}}
    for i in properties_keys_list["clids"]:
        properties["clids"][i] = get_property_from_file(i, all_build_props)

    for i in properties_keys_list["product_props"]:
        properties["product_props"][i] = get_property_from_file(i, all_build_props)

    if "ro.product.fingerprint" in properties_keys_list["product_props"]:
        properties["fingerprint"] = get_property_from_file("ro.product.fingerprint", all_build_props)

    if properties_keys_list.get("uniota_props") is not None:
        properties["uniota_props"] = {"ro.yndx.dimlist": get_property_from_file("ro.yndx.dimlist", all_build_props)}
        properties["uniota_props_keys"] = str(properties["uniota_props"]["ro.yndx.dimlist"]).split(",")
        logging.info(">>> uniota_props_keys - {}".format(properties["uniota_props_keys"]))
        for i in properties["uniota_props_keys"]:
            properties["uniota_props"]["ro.yndx.dim.{}".format(i)] = get_property_from_file("ro.yndx.dim.{}".format(i),
                                                                                            all_build_props)

    properties["logo_images"] = properties_keys_list["logo_images"]

    for image in properties["logo_images"]:
        if ".raw" in image:
            logging.info("convert raw images to jpg")
            logging.info("convert image: {}".format(image))
            convert_logo_image(resource_path, image, result_path)
            logging.info("update image name in list")
            index = properties["logo_images"].index(image)
            properties["logo_images"][index] = image.replace('.raw', '.jpg')

    properties["remote_images"] = properties_keys_list["remote_images"]

    return properties


def save_properties_to_file(properties, platform, target, result_path):
    with open("{}/properties.txt".format(result_path), "w+") as f:
        for i in properties:
            f.write(i + "=" + str(properties[i]) + "\n")

    report = generate_head_for_html_report(platform, target, "Target properties")
    report += "<h2><font color = #00b300>clids:</font></h2>"
    for i in properties["clids"].keys():
        report += "<p>{}: ".format(i) + str(properties["clids"][i]) + "</p>"

    report += "<h2><font color = #00b300>build props:</font></h2>"
    for i in properties["product_props"].keys():
        report += "<p>{}: ".format(i) + str(properties["product_props"][i]) + "</p>"

    if properties.get("uniota_props") is not None:
        report += "<h2><font color = #00b300>uni ota props:</font></h2>"
        for i in properties["uniota_props"]:
            report += "<p>{}=".format(i) + str(properties["uniota_props"][i]) + "</p>"

    report += "<h2><font color = #00b300>remote controller images:</font></h2>"
    for i in properties["remote_images"].keys():
        report += "<img src='{0}' width='{1}' height='{2}'>".format(i, properties["remote_images"][i]["width"],
                                                                    properties["remote_images"][i]["height"])

    report += "<h2><font color = #00b300>logo images:</font></h2>"
    for i in properties["logo_images"]:
        report += "<img src='{}' width='480px' height='270px'>".format(i)
    report += "</body></html>"

    html_file = open("{}/properties.html".format(result_path), "w")
    html_file.write(report)
    html_file.close()
