import logging
import os
import shutil


def get_base_properties():
    return {"clids": ["yndx.config.clid1",
                      "yndx.config.clid100010",
                      "yndx.config.clid100011",
                      "yndx.config.clid100012",
                      "yndx.config.clid100013",
                      "yndx.config.clid100014"],
            "product_props": ["ro.product.brand",
                              "ro.product.name",
                              "ro.product.device",
                              "ro.product.model",
                              "ro.product.manufacturer"],
            "remote_images": {"suw_rc_pairing_image.png": {"width": "90px", "height": "232px"},
                              "suw_rc_pairing_image_alice.png": {"width": "90px", "height": "232px"},
                              "suw_rc_image.png": {"width": "57px", "height": "195px"},
                              "suw_rc_image_alice.png": {"width": "57px", "height": "195px"}}
            }


def echo_title(title):
    line_split = "*************************************************************************************"
    logging.info("")
    logging.info(line_split)
    logging.info("   {}".format(title))
    logging.info(line_split)


def read_file(path):
    if os.path.isfile(path):
        with open(path, "r") as file_name:
            return file_name.read()
    else:
        logging.info("File not exist in path {}".format(path))
        return ""


def copy_files(from_dir, to_dir):
    files = os.listdir(str(from_dir))
    for file_name in files:
        shutil.copy2(os.path.join(str(from_dir), file_name), str(to_dir))


def generate_head_for_html_report(platform, target, title):
    result = "<html><head><title>{}</title></head><body>".format(title)
    result += "<h1>{}</h1>".format(title)
    result += "<p>platform: " + platform + "</p>"
    result += "<p>target: " + target + "</p>"
    return result


def generate_build_info_for_task(sandbox_task_id, json_url, report_resource_task_id):
    sandbox_task_base_url = "https://sandbox.yandex-team.ru/task"
    sandbox_artifacts_base_url = "https://proxy.sandbox.yandex-team.ru/task"
    result = "\n**Target tests results** - "
    result += "{}/{}/target_check_reports/test_results.html\n".format(sandbox_artifacts_base_url, sandbox_task_id)
    result += "**Target properties** - "
    result += "{}/{}/target_check_reports/properties.html\n".format(sandbox_artifacts_base_url, sandbox_task_id)
    result += "**Sandbox task with tests** - {}/{}/view\n".format(sandbox_task_base_url, sandbox_task_id)
    result += "**Json config for target build** - {}\n".format(json_url)
    result += "**Sandbox task for build rom** - {}/{}/view\n".format(sandbox_task_base_url, report_resource_task_id)
    result += "**Branch for source code** - {}\n".format("None")
    result += "**Branch for yandex apps** - {}".format("None")
    return result


def generate_report_text(properties, sandbox_task_id, json_url, report_resource_task_id):
    report_text = "**clids:**\n%%"
    for i in properties["clids"].keys():
        report_text += "{}={}\n".format(i, properties["clids"][i])

    report_text += "%%\n**build props:**\n%%"
    for i in properties["product_props"].keys():
        report_text += "{}={}\n".format(i, properties["product_props"][i])
    report_text += "%%"

    if properties.get("uniota_props_keys") is not None:
        report_text += "\n**uni ota props:**\n%%"
        for i in properties["uniota_props"]:
            report_text += "{}={}\n".format(i, properties["uniota_props"][i])
        report_text += "%%"

    report_text += generate_build_info_for_task(sandbox_task_id, json_url, report_resource_task_id)
    return report_text


def generate_attachments_list(properties, reports_path):
    path_list = []
    for i in properties["remote_images"].keys():
        path_list.append("{}/{}".format(reports_path, i))
    for i in properties["logo_images"]:
        path_list.append("{}/{}".format(reports_path, i))
    attachments = []
    for path in path_list:
        if os.path.isfile(path):
            attachments.append(path)
    return attachments


def convert_logo_image(resource_path, image_name, result_path):
    from PIL import Image
    full_hd_size = (1920, 1080)
    hd_size = (1280, 720)
    channels = 3
    with open(os.path.join(str(resource_path), image_name), "rb") as logo_file:
        data = logo_file.read()
        size = None

        if len(data) == hd_size[0] * hd_size[1] * channels:
            size = hd_size
        elif len(data) == full_hd_size[0] * full_hd_size[1] * channels:
            size = full_hd_size

        if size is None:
            logging.info("convert_logo_image: Bootlogo size cannot be estimated. Copy bootfile.raw")
        else:
            with Image.frombytes("RGB", size, data, "raw", "RGB", 0, 1) as image:
                image.save(os.path.join(str(result_path), image_name.replace('.raw', '.jpg')))
            logging.info("convert_logo_image: Bootlogo has been converted successfully")
