import sandbox.projects.quasar.platform as quasar_platform
from sandbox.projects.tv.target_check.common import TargetCheck
from sandbox.projects.tv.target_check.common.utils import get_base_properties


class TargetCheckCv6681(TargetCheck):
    """
    Check build props from TV image and compare with target config
    """

    class Parameters(TargetCheck.Parameters):
        platform = quasar_platform.Platform.YANDEX_TV_MT6681_CV
        properties_keys_list = get_base_properties()
        properties_keys_list["uniota_props"] = "ro.yndx.dimlist"
        properties_keys_list["logo_images"] = ["boot0.jpg", "boot_error.jpg", "boot_recovery.jpg"]
