import sandbox.projects.quasar.platform as quasar_platform
from sandbox.projects.tv.target_check.common import TargetCheck
from sandbox.projects.tv.target_check.common.utils import get_base_properties


class TargetCheckHikeen2842(TargetCheck):
    """
    Check build props from TV image and compare with target config
    """

    class Parameters(TargetCheck.Parameters):
        platform = quasar_platform.Platform.YANDEX_TV_RT2842_HIKEEN
        properties_keys_list = get_base_properties()
        properties_keys_list["product_props"].append("ro.build.fingerprint")
        properties_keys_list["logo_images"] = ["bootfile.raw"]
