from functools import reduce


def safe_get(dictionary, path, default=None):
    return reduce(lambda d, key: d.get(key, default) if isinstance(d, dict) else default, path.split("."), dictionary)


if __name__ == "__main__":
    data = {'employee': {'name': {'first': 'Vasya'}}}
    assert safe_get(data, "employee.name.first") == 'Vasya'
    assert safe_get(data, "employee.name") == {'first': 'Vasya'}
    assert safe_get(data, "employee.name.lastname") is None
    assert safe_get(data, "contactor.name.lastname", default="No value") == "No value"
    assert safe_get(data, "contactor.another.name", default="n/a") == "n/a"
    assert safe_get(None, "some.path", default="n/a in None dict") == "n/a in None dict"
