# -*- coding: utf-8 -*-

from dict_util import safe_get
import logging

# hard coding all rubrics from:
# https://altay.yandex-team.ru/rubrics/30154 (Medicine & Pharm group)
# and 2 from #https://altay.yandex-team.ru/rubrics/31091 (Realty)
# as per GEOPROD-1272
# todo calculate rubrics automaticaally from rubric groups given
MEDICINE_AND_PHARM_RUBRICS = {
    20269: "Medical examination",
    30074: "Hospice",
    30075: "Nursing service",
    30076: "Forensic medical examination",
    30077: "Psychotherapy",
    30079: "AIDS Prevention Center",
    30080: "Patient transport",
    30081: "Alternative medicine",
    30083: "Medical lab",
    30084: "Medical-social examination",
    30085: "Massage Salon",
    30087: "Medical tourism",
    30088: "Hair treatment",
    30089: "Vision correction",
    31610: "Morgue",
    31635: "Home Care",
    31658: "Private practice doctors",

    30056: "Dental clinics",
    30057: "Dental outpatient clinic",
    283014905: "Dental hospital",

    30061: "Ambulance service",
    30062: "Children's ER",

    30064: "Urology center",
    30065: "Medical rehabilitation centre",
    30066: "Wellness center",
    30067: "Drug abuse clinic",
    30068: "Medical center, clinic",
    30069: "Diagnostic center",
    30072: "Gynecology clinic",
    3501478889: "Family planning clinic",
    3501479437: "Perinatal medical centre",
    3501479439: "Salt cave",

    30058: "Dental materials and equipment",
    30092: "Endoscopic Ultrasound equipment",
    30093: "Health products",
    30094: "Hearing aids",
    30095: "Opticial store",
    30096: "Medical equipment repairs",
    30097: "Glasses and frames",
    30098: "Orthopedic goods",
    30099: "Medical equipment",
    30100: "Medical Consumables",
    30101: "Medical goods and consumables",
    30102: "Medical furniture",
    30103: "Medical goods store",
    30104: "Lab equipment",
    30105: "Medical glass",
    30106: "Contact lenses",
    30107: "Disability aids",
    30108: "Manufacture of prosthetic and orthopedic products",
    30109: "Diagnostic equipment",
    286801534: "Dental laboratory",
    1195608809: "Massage equipment",

    30111: "Injury care center",
    30112: "Blood donation center",
    30113: "Maternity home",
    30114: "Adult outpatient clinic",
    30115: "Medical unit",
    30116: "Women's health",
    30127: "Dispensary",
    30128: "Children's clinic",
    30129: "Military hospital",
    30141: "Children's hospital",
    30142: "Hospital",
    30144: "Ambulatory",
    31638: "Psychiatric Hospital",
    144152360: "Specialized hospital",

    30146: "Pharmaceutical equipment",
    30147: "Pharmaceutical company",
    30148: "Pharmacy reference service",
    30149: "Herbal medicines",
    30151: "Pharmacy",
    30152: "Phytoproducts, dietary supplements",

    30207: "Tattoos"
}

# Only new buildings from https://altay.yandex-team.ru/rubrics/31091
REALTY = {
    1191769628: "Housing complex",
    31118:	"Flats in New Buildings"
}

# TODO fetch translations from tanker or remove them, as per GEOPROD-1272 they are not currently needed
# @see https://tanker.yandex-team.ru/?project=sprav&branch=master&keyset=core%3A_main
# @see https://tanker.yandex-team.ru/?project=direct&branch=to-islands-v4&keyset=core:_BannerFlags
DISCLAIMERS = {
    "abortion": {
        "ru": "Есть противопоказания. Посоветуйтесь с врачом. Возможен вред здоровью.",
        "uk": "Є протипоказання. Порадьтеся з лікарем. Можлива шкода здоров'ю.",
        "en": "Contraindications apply. Consult your doctor. May cause possible adverse side effects.",
        "tr": "Yan etkiler görülebilir. Doktorunuza danışın. Sağlığa zararlı olabilir."
    },
    "medicine": {
        "ru": "Есть противопоказания. Посоветуйтесь с врачом.",
        "uk": "Є протипоказання. Порадьтеся з лікарем.",
        "en": "Contraindications apply. Consult your doctor.",
        "tr": "Yan etkiler görülebilir. Doktorunuza danışın.",
    },
    "alcohol": {
        "ru": "Чрезмерное потребление вредно.",
        "uk": "Надмірне споживання шкідливе.",
        "tr": "Aşırı tüketilmesi zararlıdır.",
        "en": "Enjoy in moderation.",
    },
    "tobacco": {
        "ru": "Курение вредит вашему здоровью",
        "uk": "Паління шкодить вашому здоров'ю",
        "tr": "Sigara sağlığa zararlıdır",
        "en": "Smoking kills",
    },
    "dietary_supplements": {
        "ru": "БАД",
        "uk": "БАД",
        "tr": "Besin desteği",
        "en": "Dietary supplement",
    },
    "pseudo_weapon": {
        "ru": "Конструктивно сходные с оружием изделия",
        "uk": "Конструктивно схожі на зброю вироби",
        "tr": "Yapısal olarak silaha benzeyen ürünler",
        "en": "Item's design bears resemblance to weapons",
    },
    "realty": {
        "ru": "Проектная декларация на сайте наш.дом.рф",
    }
}

RUBRICS_PER_CAT = {
    "medicine": MEDICINE_AND_PHARM_RUBRICS,
    "realty": REALTY
}


def get_disclaimers(rubrics, lang):
    rubric_set = set(rubrics)
    cats = [cat for cat in RUBRICS_PER_CAT.keys() if set(RUBRICS_PER_CAT[cat].keys()) & set(rubric_set)]
    disclaimers = []
    for cat in cats:
        disclaimer = safe_get(DISCLAIMERS, ".".join([cat, lang]))
        if not disclaimer:
            logging.error("Unable to get disclaimer text for category=%s, lang=%s!", cat, lang)
        else:
            disclaimers.append(disclaimer)
    return disclaimers


if __name__ == "__main__":
    assert get_disclaimers([30056], "ru") == [DISCLAIMERS["medicine"]["ru"]]
    assert get_disclaimers([1191769628], "ru") == [DISCLAIMERS["realty"]["ru"]]
