# coding: utf-8

import sandbox.common.types.client as ctc

import sandbox.projects.common.build.parameters
from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.common.nanny import nanny
import sandbox.projects.ugc.resources as resources


def _get_unneeded_params_groups():
    groups = set([
        sandbox.projects.common.build.parameters.TEST_SYSTEM_GROUP_NAME,
        sandbox.projects.common.build.parameters.JAVA_GROUP_NAME,
    ])
    for p in YaMakeTask.input_parameters:
        if p.name == 'targets':
            groups.add(p.group)
            break
    return groups


class BuildUgcDbBackend(YaMakeTask, nanny.ReleaseToNannyTask):
    type = 'BUILD_UGC_DB_BACKEND'
    client_tags = ctc.Tag.Group.LINUX
    cores = 24

    input_parameters = [p for p in YaMakeTask.input_parameters if p.group not in _get_unneeded_params_groups()]

    execution_space = 150 * 1024  # 150 GB

    def get_targets(self):
        return [
            'entity/ugc/server/bin',
            'entity/ugc/server/config',
        ]

    def get_arts(self):
        return [
            {'path': 'entity/ugc/server/bin/ugcserver'},
            {'path': 'entity/ugc/server/config/entity/ugc/server/config'},
        ]

    def get_resources(self):
        return {
            'ugcserver': {
                'resource_type': resources.UgcDbBackendExecutable,
                'description': 'Ugc Server executable',
                'resource_path': 'ugcserver',
            },
            'config': {
                'resource_type': resources.UgcComponentServerConfigDir,
                'description': 'Ugc Server config directory',
                'resource_path': 'config',
            },
        }

    def on_release(self, additional_parameters):
        additional_parameters['release_comments'] += 'UGC DB backend release\n'

        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        YaMakeTask.on_release(self, additional_parameters)


__Task__ = BuildUgcDbBackend
