# -*- coding: utf-8 -*-

import sandbox.common.types.client as ctc

from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.common.nanny import nanny

import sandbox.projects.common.build.parameters as build_params

import sandbox.projects.ugc.resources as resources


class BuildUgcNotificationSender2(YaMakeTask, nanny.ReleaseToNannyTask):
    """
        Build UGC notification_sender2
    """

    type = 'BUILD_UGC_NOTIFICATION_SENDER2'
    client_tags = ctc.Tag.Group.LINUX
    cores = 24

    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.ArcadiaPatch,
        build_params.DefinitionFlags,
        build_params.TestParameter,
        build_params.UseArcadiaApiFuse,
        build_params.CheckoutParameter,
        build_params.CheckoutModeParameter,
        build_params.ClearBuild,
        build_params.BuildType,
    ]

    def get_targets(self):
        return [
            'entity/ugc/notification_sender2',
        ]

    def get_arts(self):
        return [
            {'path': 'entity/ugc/notification_sender2/bin/ugc_notification_sender'},
        ]

    def get_arts_source(self):
        return [
        ]

    def get_resources(self):
        project = {}
        project['resource_type'] = resources.UgcNotificationSender2
        project['description'] = 'UGC notification_sender2 files'
        project['resource_path'] = ''
        return {'project': project}

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        YaMakeTask.on_release(self, additional_parameters)


__Task__ = BuildUgcNotificationSender2
