# coding=utf-8
import logging
import os

logger = logging.getLogger(__name__)


class PutVaultDataToHome(object):
    CONFIG_TEMPLATE = '''
[distutils]
index-servers =
    yandex

[yandex]
repository: https://pypi.yandex-team.ru/simple/
username: {access_key}
password: {secret_key}

    '''

    def __init__(self, access_key, secret_key, debug):
        self.restore_original_pypirc = False
        self.original_pypirc_backup = None
        self.config_path = os.path.expanduser('~/.pypirc')

        self.access_key = access_key
        self.secret_key = secret_key
        self.debug = debug

    def __enter__(self):
        logger.debug("Prepare %s", self.config_path)
        if os.path.exists(self.config_path):
            self.restore_original_pypirc = True
            self.original_pypirc_backup = self.config_path + '_backup'
            os.rename(self.config_path, self.original_pypirc_backup)

        with open(self.config_path, 'w') as f:
            f.write(
                PutVaultDataToHome.CONFIG_TEMPLATE.format(
                    access_key=self.access_key,
                    secret_key=self.secret_key
                )
            )
            f.flush()
            os.fsync(f.fileno())

        if self.debug:
            with open(self.config_path, 'r') as f:
                logger.debug("Current config %s contains:\n %s", self.config_path, f.read())

    def __exit__(self, *args):
        os.remove(self.config_path)
        if self.restore_original_pypirc:
            os.rename(self.original_pypirc_backup, self.config_path)
